/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.ss.framework.project.internal.core.model.options;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.silabs.java.utils.ArrayUtils;
import com.silabs.ss.framework.project.api.core.model.MConvertedOption;
import com.silabs.ss.framework.project.api.core.model.MGenericOption;
import com.silabs.ss.framework.project.api.core.model.MSettingsSite;
import com.silabs.ss.framework.project.api.core.model.MSpecificOption;
import com.silabs.ss.framework.project.api.core.model.options.ConvertedOptionsUtils;
import com.silabs.ss.framework.project.api.core.model.options.GenericBuildOptions;
import com.silabs.ss.framework.project.api.core.model.options.IOptionMapping;
import com.silabs.ss.framework.project.api.core.model.options.IOptionMappingEngine;
import com.silabs.ss.framework.project.api.core.model.options.IOptionMappingRegistry;
import com.silabs.ss.framework.project.api.core.model.options.IReverseOptionMapping;
import com.silabs.ss.framework.project.internal.core.model.Activator;
import com.silabs.ss.platform.api.descriptor.core.property.model.IProperty;
import com.silabs.ss.platform.api.descriptor.core.property.model.Property;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public abstract class BaseOptionMappingEngine<OutgoingOption extends MConvertedOption, IncomingMapping extends IOptionMapping<OutgoingOption>, OutgoingMapping extends IReverseOptionMapping<OutgoingOption>>
implements IOptionMappingEngine {
    private IOptionMappingRegistry<OutgoingOption, IncomingMapping, OutgoingMapping> mappings;
    private Deque<Multimap<IProperty, OutgoingOption>> exportContexts = new ArrayDeque<Multimap<IProperty, OutgoingOption>>();
    protected Deque<Map<String, MSpecificOption>> existingSpecificOptions = new ArrayDeque<Map<String, MSpecificOption>>();
    private Class<OutgoingOption> outgoingClass;

    public BaseOptionMappingEngine(Class<OutgoingOption> outgoingClass, IOptionMappingRegistry<OutgoingOption, IncomingMapping, OutgoingMapping> mappings) {
        this.outgoingClass = outgoingClass;
        this.mappings = mappings;
    }

    @Override
    public void createSpecificOption(IProperty externalOption, Object value, MSettingsSite settings) {
        ConvertedOptionsUtils.findOrCreateSpecificOption(settings, externalOption, value);
    }

    @Override
    public void importOptions(MSettingsSite settings) {
        MConvertedOption[] cvts;
        MConvertedOption[] mConvertedOptionArray = cvts = (MConvertedOption[])settings.getConvertedOptions().toArray((Object[])new MConvertedOption[settings.getConvertedOptions().size()]);
        int n = cvts.length;
        int n2 = 0;
        while (n2 < n) {
            MConvertedOption cvt = mConvertedOptionArray[n2];
            if (cvt instanceof MSpecificOption) {
                IOptionMapping[] opMaps;
                MSpecificOption spec = (MSpecificOption)cvt;
                IProperty externalOption = (IProperty)Property.registry().findDescriptor(spec.getOptionId());
                if (externalOption != null && (opMaps = this.mappings.findOptionMappings(externalOption)) != null) {
                    IOptionMapping[] iOptionMappingArray = opMaps;
                    int n3 = opMaps.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IOptionMapping opMap = iOptionMappingArray[n4];
                        MConvertedOption[] outs = opMap.mapToOutgoing(spec);
                        if (outs != null) {
                            this.updateSettingsSiteForImport(settings, spec, outs);
                        }
                        ++n4;
                    }
                }
            }
            ++n2;
        }
    }

    protected abstract void updateSettingsSiteForImport(MSettingsSite var1, MSpecificOption var2, OutgoingOption[] var3);

    @Override
    public MSpecificOption[] exportOptions(MSettingsSite site) {
        try {
            this.pushExportContext(site);
            MSpecificOption[] mSpecificOptionArray = this.doExportOptions(site);
            return mSpecificOptionArray;
        }
        finally {
            this.popExportContext();
        }
    }

    protected MSpecificOption[] doExportOptions(MSettingsSite site) {
        Multimap<IProperty, OutgoingOption> map = this.exportContexts.peek();
        Map<String, MSpecificOption> existingSpecifics = this.existingSpecificOptions.peek();
        ArrayList<MSpecificOption> specifics = new ArrayList<MSpecificOption>();
        while (!map.isEmpty()) {
            IReverseOptionMapping[] specificMappings;
            boolean changed = false;
            IReverseOptionMapping[] iReverseOptionMappingArray = specificMappings = this.mappings.findReverseOptionMappings(map.keySet());
            int n = specificMappings.length;
            int n2 = 0;
            while (n2 < n) {
                IReverseOptionMapping specificMapping = iReverseOptionMappingArray[n2];
                MConvertedOption[] toConvert = (MConvertedOption[])ArrayUtils.toArray(this.outgoingClass, (Collection)map.values());
                MSpecificOption specific = specificMapping.mapToExternal(toConvert);
                if (specific != null && !existingSpecifics.containsKey(specific.getOptionId())) {
                    specifics.add(specific);
                    Iterator iter = map.values().iterator();
                    while (iter.hasNext()) {
                        MConvertedOption gen = (MConvertedOption)iter.next();
                        if (!this.outgoingCoversIncoming(gen, specific)) continue;
                        if (gen instanceof MGenericOption) {
                            specific.getGenericMappings().add((Object)((MGenericOption)gen));
                            specific.appendSelectable(gen);
                        }
                        iter.remove();
                    }
                    changed = true;
                }
                ++n2;
            }
            if (!changed) break;
        }
        for (MSpecificOption specific : specifics) {
            site.getConvertedOptions().add((Object)specific);
            Iterator iter = site.getConvertedOptions().iterator();
            while (iter.hasNext()) {
                MConvertedOption cvt = (MConvertedOption)iter.next();
                if (!(cvt instanceof MGenericOption) || !((MGenericOption)cvt).getSpecificMappings().contains((Object)specific)) continue;
                iter.remove();
            }
        }
        specifics.addAll(existingSpecifics.values());
        return specifics.toArray(new MSpecificOption[specifics.size()]);
    }

    protected abstract boolean outgoingCoversIncoming(OutgoingOption var1, MSpecificOption var2);

    @Override
    public void pushExportContext(MSettingsSite site) {
        ArrayListMultimap newMap = !this.exportContexts.isEmpty() ? ArrayListMultimap.create(this.exportContexts.peek()) : ArrayListMultimap.create();
        List<OutgoingOption> generics = this.gatherOutgoing(site);
        Map<String, MSpecificOption> specifics = this.gatherExistingSpecific(site);
        for (MConvertedOption generic : generics) {
            IProperty genericOpt = GenericBuildOptions.registry().findGenericOption(generic.getToolId(), generic.getOptionId());
            if (genericOpt == null) {
                Activator.reporter.logError("unknown generic option: " + String.valueOf(generic) + " at " + String.valueOf(site));
                continue;
            }
            if (newMap.containsEntry((Object)genericOpt, (Object)generic)) continue;
            newMap.put((Object)genericOpt, (Object)generic);
        }
        this.exportContexts.push((Multimap<IProperty, OutgoingOption>)newMap);
        this.existingSpecificOptions.push(specifics);
    }

    protected abstract List<OutgoingOption> gatherOutgoing(MSettingsSite var1);

    protected abstract Map<String, MSpecificOption> gatherExistingSpecific(MSettingsSite var1);

    @Override
    public void popExportContext() {
        this.exportContexts.pop();
        this.existingSpecificOptions.pop();
    }
}

