/*
 * Decompiled with CFR 0.152.
 */
package com.silabs.ss.support.internal.lua;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.primitives.Ints;
import com.silabs.java.utils.ExceptionUtils;
import com.silabs.java.utils.Pair;
import com.silabs.ss.support.api.lua.ILuaApiLibrary;
import com.silabs.ss.support.api.lua.LuaApi;
import com.silabs.ss.support.api.lua.LuaCreator;
import com.silabs.ss.support.api.lua.LuaProperty;
import com.silabs.ss.support.api.lua.util.LuaValueUtils;
import com.silabs.ss.support.internal.lua.InternalConverter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.luaj.vm2.LuaError;
import org.luaj.vm2.LuaNumber;
import org.luaj.vm2.LuaTable;
import org.luaj.vm2.LuaValue;
import org.luaj.vm2.Varargs;
import org.luaj.vm2.lib.OneArgFunction;
import org.luaj.vm2.lib.ThreeArgFunction;
import org.luaj.vm2.lib.TwoArgFunction;
import org.luaj.vm2.lib.VarArgFunction;
import org.luaj.vm2.lib.ZeroArgFunction;

public class LuaLibraryConverter {
    private static final ImmutableMap<Class<?>, InternalConverter> conversionTables;

    static {
        ImmutableMap.Builder conversionBuilder = ImmutableMap.builder();
        InternalConverter byteConverters = new InternalConverter(LuaValue::isint, luna -> (byte)luna.toint(), jav -> jav instanceof Byte, jav -> LuaValue.valueOf((int)((Byte)jav).byteValue()));
        conversionBuilder.put(Byte.class, (Object)byteConverters);
        conversionBuilder.put(Byte.TYPE, (Object)byteConverters);
        InternalConverter shortConverters = new InternalConverter(LuaValue::isint, luna -> (short)luna.toint(), jav -> jav instanceof Short, jav -> LuaValue.valueOf((int)((Short)jav).shortValue()));
        conversionBuilder.put(Short.class, (Object)shortConverters);
        conversionBuilder.put(Short.TYPE, (Object)shortConverters);
        InternalConverter intConverters = new InternalConverter(LuaValue::isint, luna -> luna.toint(), jav -> jav instanceof Integer, jav -> LuaValue.valueOf((int)((Integer)jav)));
        conversionBuilder.put(Integer.class, (Object)intConverters);
        conversionBuilder.put(Integer.TYPE, (Object)intConverters);
        InternalConverter longConverters = new InternalConverter(LuaValue::islong, luna -> luna.tolong(), jav -> jav instanceof Long, jav -> LuaValue.valueOf((double)((Long)jav).longValue()));
        conversionBuilder.put(Long.class, (Object)longConverters);
        conversionBuilder.put(Long.TYPE, (Object)longConverters);
        InternalConverter floatConverters = new InternalConverter(LuaValue::isnumber, luna -> Float.valueOf(luna.tofloat()), jav -> jav instanceof Float, jav -> LuaValue.valueOf((double)((Float)jav).floatValue()));
        conversionBuilder.put(Float.class, (Object)floatConverters);
        conversionBuilder.put(Float.TYPE, (Object)floatConverters);
        InternalConverter doubleConverters = new InternalConverter(LuaValue::isnumber, luna -> luna.todouble(), jav -> jav instanceof Double, jav -> LuaValue.valueOf((double)((Double)jav)));
        conversionBuilder.put(Double.class, (Object)doubleConverters);
        conversionBuilder.put(Double.TYPE, (Object)doubleConverters);
        InternalConverter characterConverters = new InternalConverter(LuaValue::isstring, luna -> Character.valueOf(luna.tojstring().charAt(0)), jav -> jav instanceof Character, jav -> LuaValue.valueOf((int)((Character)jav).charValue()));
        conversionBuilder.put(Character.class, (Object)characterConverters);
        conversionBuilder.put(Character.TYPE, (Object)characterConverters);
        InternalConverter booleanConverters = new InternalConverter(LuaValue::isboolean, LuaValue::toboolean, jav -> jav instanceof Boolean, jav -> LuaValue.valueOf((boolean)((Boolean)jav)));
        conversionBuilder.put(Boolean.class, (Object)booleanConverters);
        conversionBuilder.put(Boolean.TYPE, (Object)booleanConverters);
        conversionBuilder.put(String.class, (Object)new InternalConverter(LuaValue::isstring, LuaValue::tojstring, jav -> jav instanceof String, jav -> LuaValue.valueOf((String)((String)jav))));
        conversionBuilder.put(Map.class, (Object)new InternalConverter(LuaValue::istable, LuaLibraryConverter::tableToMap, null, null));
        conversionBuilder.put(Set.class, (Object)new InternalConverter(LuaValue::istable, LuaLibraryConverter::tableToSet, null, null));
        conversionBuilder.put(List.class, (Object)new InternalConverter(LuaValue::istable, LuaLibraryConverter::tableToList, null, null));
        conversionTables = conversionBuilder.build();
    }

    private LuaLibraryConverter() {
    }

    public static LuaTable convertLibrary(ILuaApiLibrary library) {
        LuaTable lt = new LuaTable();
        lt.set("lua_library_classname", library.getClass().getName());
        Method[] methodArray = library.getClass().getMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method m = methodArray[n2];
            if (m.getAnnotation(LuaApi.class) != null) {
                lv = LuaLibraryConverter.convertMethod(library, m);
                lt.set(m.getName(), lv);
            } else if (m.getAnnotation(LuaProperty.class) != null) {
                lv = LuaLibraryConverter.convertProperty(library, m);
                lt.set(m.getName(), lv);
            }
            ++n2;
        }
        return lt;
    }

    private static void typeError(Object x, Class<?> expected) {
        throw new LuaError("Invalid java type. Expecting: '" + expected.getName() + "', got '" + x.getClass().getName() + "'");
    }

    private static void paramError(LuaValue arg, Class<?> expected) {
        throw new LuaError("Can't convert lua value '" + arg.toString() + "' to '" + expected.getClass().getName() + "'");
    }

    public static Object convertValueToExpectedType(Class<?> expectedType, LuaValue arg) {
        if (arg.isnil()) {
            return null;
        }
        InternalConverter functions = (InternalConverter)conversionTables.get(expectedType);
        if (functions != null) {
            if (Boolean.TRUE.equals(functions.canLuaConvertToJava.apply(arg))) {
                return functions.convertLuaToJava.apply(arg);
            }
        } else {
            if (Arrays.stream(expectedType.getInterfaces()).anyMatch(i -> i == ILuaApiLibrary.class)) {
                if (arg.istable()) {
                    Map<Object, Object> rawProperties = LuaLibraryConverter.tableToMap(arg);
                    return LuaLibraryConverter.tableToJavaType(rawProperties, expectedType);
                }
                throw new LuaError("Cannot convert to Java objects unless Lua type is table. Got " + arg);
            }
            throw new LuaError("Converting lua value to " + expectedType + " not supported.");
        }
        LuaLibraryConverter.paramError(arg, expectedType);
        return null;
    }

    private static Object tableToJavaType(Map<Object, Object> table, Class<?> expectedType) {
        List luaConstructors = Arrays.stream(expectedType.getMethods()).filter(m -> m.getAnnotation(LuaCreator.class) != null).collect(Collectors.toList());
        if (luaConstructors.isEmpty()) {
            throw new LuaError("Cannot create " + expectedType + " as there is no @LuaCreator annotated method.");
        }
        if (luaConstructors.size() > 1) {
            throw new LuaError("Type " + expectedType + " has too many @LuaCreator annotated methods. Only one allowed.");
        }
        Method luaConstructor = (Method)luaConstructors.get(0);
        LuaCreator constructor = luaConstructor.getAnnotation(LuaCreator.class);
        Object[] orderedArguments = Arrays.stream(constructor.value()).map(table::get).toArray();
        Parameter[] expectedParams = luaConstructor.getParameters();
        int i = 0;
        while (i < luaConstructor.getParameterCount()) {
            Parameter param = expectedParams[i];
            Object arg = orderedArguments[i];
            if (arg instanceof Collection && ((Collection)arg).isEmpty() || arg == null) {
                if (param.getType().isAssignableFrom(Set.class)) {
                    orderedArguments[i] = new HashSet();
                } else if (param.getType().isAssignableFrom(Map.class)) {
                    orderedArguments[i] = new HashMap();
                } else if (param.getType().isAssignableFrom(List.class)) {
                    orderedArguments[i] = new ArrayList();
                }
            }
            ++i;
        }
        try {
            Object constructed = luaConstructor.invoke(null, orderedArguments);
            if (constructed != null && constructed.getClass() != expectedType) {
                throw new LuaError("Type " + expectedType + " MUST have @LuaCreator annotated method return the same type as the object!");
            }
            return constructed;
        }
        catch (Exception e) {
            throw LuaLibraryConverter.handleReflectiveExceptions(e);
        }
    }

    public static Object nullIfEmpty(Object a) {
        if (a instanceof Collection && ((Collection)a).isEmpty()) {
            return null;
        }
        return a;
    }

    private static Map<Object, Object> tableToMap(LuaValue arg) {
        return LuaValueUtils.tableEntrySet(arg).stream().map(pair -> Pair.of((Object)LuaLibraryConverter.convertValue((LuaValue)pair.first()), (Object)LuaLibraryConverter.convertValue((LuaValue)pair.second()))).collect(Collectors.toMap(Pair::first, Pair::second));
    }

    private static List<Object> tableToList(LuaValue arg) {
        return LuaValueUtils.tableEntrySet(arg).stream().filter(pair -> ((LuaValue)pair.first()).isint()).sorted((pairL, pairR) -> Ints.compare((int)((LuaValue)pairL.first()).checkint(), (int)((LuaValue)pairR.first()).checkint())).map(pair -> LuaLibraryConverter.convertValue((LuaValue)pair.second())).collect(Collectors.toList());
    }

    private static Set<Object> tableToSet(LuaValue arg) {
        return LuaValueUtils.tableEntrySet(arg).stream().filter(pair -> ((LuaValue)pair.second()).isboolean()).filter(pair -> ((LuaValue)pair.second()).equals((Object)LuaValue.TRUE)).map(pair -> LuaLibraryConverter.convertValue((LuaValue)pair.first())).collect(Collectors.toSet());
    }

    public static Object convertValue(LuaValue value) {
        if (value == null || value.isnil()) {
            return LuaValue.NIL;
        }
        if (value.isboolean()) {
            return value.toboolean();
        }
        if (value instanceof LuaNumber && value.isint()) {
            return value.toint();
        }
        if (value instanceof LuaNumber && value.islong()) {
            return value.tolong();
        }
        if (value instanceof LuaNumber && value.isnumber()) {
            return value.todouble();
        }
        if (value.istable()) {
            return LuaLibraryConverter.setListOrMap(value);
        }
        if (value.isstring()) {
            return value.tojstring();
        }
        if (value.isclosure()) {
            return value.checkclosure();
        }
        if (value.isfunction()) {
            return value.checkfunction();
        }
        return LuaValue.NIL;
    }

    public static Object setListOrMap(LuaValue table) {
        List<Pair<LuaValue, LuaValue>> entries = LuaValueUtils.tableEntrySet(table);
        if (entries.stream().allMatch(pair -> ((LuaValue)pair.first()).isint())) {
            return LuaLibraryConverter.tableToList(table);
        }
        if (entries.stream().allMatch(pair -> ((LuaValue)pair.second()).isboolean() && ((LuaValue)pair.second()).toboolean())) {
            return LuaLibraryConverter.tableToSet(table);
        }
        return LuaLibraryConverter.tableToMap(table);
    }

    private static LuaValue convertResult(Object x) throws LuaError {
        return LuaLibraryConverter.convertResult(x.getClass(), x);
    }

    private static LuaValue convertResult(Class<?> returnType, Object x) throws LuaError {
        if (returnType == Void.TYPE || x == null) {
            return LuaValue.NIL;
        }
        InternalConverter functions = (InternalConverter)conversionTables.get(returnType);
        if (functions != null && functions.hasJavaToLuaConverters()) {
            if (Boolean.TRUE.equals(functions.canJavaConvertToLua.apply(x))) {
                return functions.convertJavaToLua.apply(x);
            }
            LuaLibraryConverter.typeError(x, returnType);
        } else {
            Set<Class<?>> implementedInterfaces = LuaLibraryConverter.allInterfacesOf(returnType);
            if (implementedInterfaces.contains(ILuaApiLibrary.class)) {
                return LuaLibraryConverter.convertLibrary((ILuaApiLibrary)x);
            }
            if (returnType == Set.class || implementedInterfaces.contains(Set.class)) {
                if (x instanceof Set) {
                    return LuaLibraryConverter.setToTable((Set)x);
                }
                LuaLibraryConverter.typeError(x, Set.class);
            } else if (returnType == Map.class || implementedInterfaces.contains(Map.class)) {
                if (x instanceof Map) {
                    return LuaLibraryConverter.mapToTable((Map)x);
                }
                LuaLibraryConverter.typeError(x, Map.class);
            } else if (returnType == List.class || implementedInterfaces.contains(List.class) || returnType == Collection.class || implementedInterfaces.contains(Collection.class)) {
                if (x instanceof List) {
                    return LuaLibraryConverter.listToTable((List)x);
                }
                if (x instanceof Collection) {
                    return LuaLibraryConverter.listToTable(ImmutableList.copyOf((Collection)((Collection)x)));
                }
                LuaLibraryConverter.typeError(x, List.class);
            } else {
                throw new LuaError("Attempting to return a non-convertable lua type: " + returnType);
            }
        }
        return LuaValue.NIL;
    }

    private static Set<Class<?>> allInterfacesOf(Class<?> clazz) {
        HashSet interfaces = new HashSet();
        Class<?> next = clazz;
        while (next != null) {
            Class<?>[] classArray = next.getInterfaces();
            int n = classArray.length;
            int n2 = 0;
            while (n2 < n) {
                Class<?> inter = classArray[n2];
                interfaces.add(inter);
                ++n2;
            }
            next = next.getSuperclass();
        }
        return interfaces;
    }

    private static final LuaTable mapToTable(Map<?, ?> collection) {
        return new LuaTable((LuaValue[])collection.entrySet().stream().flatMap(entry -> Stream.builder().add(LuaLibraryConverter.convertResult(entry.getKey())).add(LuaLibraryConverter.convertResult(entry.getValue())).build()).toArray(LuaValue[]::new), null, null);
    }

    private static final LuaTable listToTable(List<?> collection) {
        return new LuaTable(null, (LuaValue[])collection.stream().map(LuaLibraryConverter::convertResult).toArray(LuaValue[]::new), null);
    }

    private static final LuaTable setToTable(Set<?> collection) {
        return new LuaTable((LuaValue[])collection.stream().flatMap(item -> Stream.builder().add(LuaLibraryConverter.convertResult(item)).add((LuaValue)LuaValue.TRUE).build()).toArray(LuaValue[]::new), null, null);
    }

    private static LuaValue convertProperty(ILuaApiLibrary library, Method m) {
        Class<?> returnType = m.getReturnType();
        Object[] params = m.getParameters();
        m.setAccessible(true);
        if (params.length > 0) {
            throw new LuaError("Cannot use @LuaProperty on a method with arguments: " + Arrays.toString(params));
        }
        try {
            Object property = m.invoke((Object)library, new Object[0]);
            return LuaLibraryConverter.convertResult(returnType, property);
        }
        catch (Exception e) {
            throw LuaLibraryConverter.handleReflectiveExceptions(e);
        }
    }

    private static LuaValue convertMethod(final ILuaApiLibrary library, final Method m) {
        final Class<?> returnType = m.getReturnType();
        final Parameter[] params = m.getParameters();
        m.setAccessible(true);
        return switch (params.length) {
            case 0 -> new ZeroArgFunction(){

                public LuaValue call() {
                    try {
                        Object result = m.invoke((Object)library, new Object[0]);
                        return LuaLibraryConverter.convertResult(returnType, result);
                    }
                    catch (Exception e) {
                        throw LuaLibraryConverter.handleReflectiveExceptions(e);
                    }
                }
            };
            case 1 -> new OneArgFunction(){

                public LuaValue call(LuaValue arg) {
                    try {
                        Object result = m.invoke((Object)library, LuaLibraryConverter.convertValueToExpectedType(params[0].getType(), arg));
                        return LuaLibraryConverter.convertResult(returnType, result);
                    }
                    catch (Exception e) {
                        throw LuaLibraryConverter.handleReflectiveExceptions(e);
                    }
                }
            };
            case 2 -> new TwoArgFunction(){

                public LuaValue call(LuaValue arg1, LuaValue arg2) {
                    try {
                        Object result = m.invoke((Object)library, LuaLibraryConverter.convertValueToExpectedType(params[0].getType(), arg1), LuaLibraryConverter.convertValueToExpectedType(params[1].getType(), arg2));
                        return LuaLibraryConverter.convertResult(returnType, result);
                    }
                    catch (Exception e) {
                        throw LuaLibraryConverter.handleReflectiveExceptions(e);
                    }
                }
            };
            case 3 -> new ThreeArgFunction(){

                public LuaValue call(LuaValue arg1, LuaValue arg2, LuaValue arg3) {
                    try {
                        Object result = m.invoke((Object)library, LuaLibraryConverter.convertValueToExpectedType(params[0].getType(), arg1), LuaLibraryConverter.convertValueToExpectedType(params[1].getType(), arg2), LuaLibraryConverter.convertValueToExpectedType(params[2].getType(), arg3));
                        return LuaLibraryConverter.convertResult(returnType, result);
                    }
                    catch (Exception e) {
                        throw LuaLibraryConverter.handleReflectiveExceptions(e);
                    }
                }
            };
            default -> new VarArgFunction(){

                public Varargs invoke(Varargs args) {
                    try {
                        Object[] javaArgs = new Object[params.length];
                        int i = 0;
                        while (i < params.length) {
                            javaArgs[i] = LuaLibraryConverter.convertValueToExpectedType(params[i].getType(), args.arg(i + 1));
                            ++i;
                        }
                        Object result = m.invoke((Object)library, javaArgs);
                        return LuaValue.varargsOf((LuaValue[])new LuaValue[]{LuaLibraryConverter.convertResult(returnType, result)});
                    }
                    catch (Exception e) {
                        throw LuaLibraryConverter.handleReflectiveExceptions(e);
                    }
                }
            };
        };
    }

    private static LuaError handleReflectiveExceptions(Exception e) {
        if (e instanceof InvocationTargetException) {
            InvocationTargetException invEx = (InvocationTargetException)e;
            Throwable target = invEx.getTargetException();
            if (target != null) {
                return new LuaError(String.valueOf(target.getLocalizedMessage()) + System.lineSeparator() + ExceptionUtils.exceptionToString((Throwable)target));
            }
        } else if (e instanceof LuaError) {
            return (LuaError)((Object)e);
        }
        return new LuaError((Throwable)e);
    }
}

